/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.profile;

import com.ibm.hsc.auiml.databeans.profile.PIFullSysProfBean;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.hsc.websm.common.ProfileUtils;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import com.ibm.websm.mobject.MObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIProfileMemoryDataBean
extends AuimlDataBeanAdapter {
    private static final String PROFILEMOBJECT = "com.ibm.hsc.websm.profile.ProfileMObject";
    private static final String LPARMOBJECT = "com.ibm.hsc.websm.lpar.LPARMObject";
    private static final String CECMOBJECT = "com.ibm.hsc.websm.cec.CECMObject";
    private static final String MIN_FOR_MAX_S = "ProfileP02Memory.MemoryMinForMax";
    private static final String MAX_GROUP_S = "ProfileP02Memory.MemoryMaxGroup";
    private static final String NOT_ENOUGH_CONFIGURABLE_MEMORY = HSCResourceBundleUtil.getMessage("ProfileBundle", "NOT_ENOUGH_CONFIGURABLE_MEMORY");
    private static final String DESIRED_MEMORY_NOT_IN_RANGE = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_MEMORY_NOT_IN_RANGE");
    private static final String MIN_MEMORY_TOO_SMALL_FOR_MAX = HSCResourceBundleUtil.getMessage("ProfileBundle", "MIN_MEMORY_TOO_SMALL_FOR_MAX");
    private static final String ZERO_MEMORY_ERROR = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NO_MEM_SEL");
    private PILPARProfileDataBean m_cimProfileBean;
    private MOXContainerObj m_moxObj;
    private MObject m_mobject;
    private MOClass m_moClass;
    private int m_memoryRegionSize;
    private long m_totalMemoryMB;
    private long m_minForMaxMemoryMB;
    private int m_minMemoryGB;
    private int m_minMemoryMB;
    private int m_desiredMemoryGB;
    private int m_desiredMemoryMB;
    private int m_maxMemoryGB;
    private int m_maxMemoryMB;
    private String m_sAvailableMem;
    private long m_configMemoryMB = 0L;

    public PIProfileMemoryDataBean(MOXContainerObj mOXContainerObj, PICECDataBean pICECDataBean, PILPARProfileDataBean pILPARProfileDataBean) {
        MOXContainerObj mOXContainerObj2;
        String string = mOXContainerObj.getMOClassName();
        if (PROFILEMOBJECT.equals(string)) {
            System.err.println("ProfileMObject");
            mOXContainerObj2 = ProfileUtils.getLPARMOXContainerObj(mOXContainerObj);
            this.m_mobject = mOXContainerObj2.getMObject();
            this.m_moClass = null;
            if (IDebug.enabled()) {
                try {
                    System.err.println("    LPAR MObject = " + this.m_mobject.getName());
                    System.err.println("    LPAR key = " + this.m_mobject.getKey());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else if (LPARMOBJECT.equals(string)) {
            System.err.println("LPARMObject");
            mOXContainerObj2 = mOXContainerObj.getMObject();
            this.m_mobject = mOXContainerObj2;
            this.m_moClass = null;
            if (IDebug.enabled()) {
                try {
                    System.err.println("    LPAR MObject = " + this.m_mobject.getName());
                    System.err.println("    LPAR key = " + this.m_mobject.getKey());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else if (CECMOBJECT.equals(string)) {
            System.err.println("CECMObject");
            this.m_mobject = null;
            this.m_moClass = mOXContainerObj.getMOClass();
            this.m_moxObj = mOXContainerObj;
            if (IDebug.enabled()) {
                try {
                    System.err.println("    CEC MOClass = " + this.m_moClass.getName());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("Expecting CECMObject, LPARMObject, or ProfileMObject, found " + string);
        }
        this.m_cimProfileBean = pILPARProfileDataBean;
        this.m_memoryRegionSize = pICECDataBean.getMemoryRegionSize().intValue();
        this.m_totalMemoryMB = pICECDataBean.getInstalledMemory().longValue();
        this.m_configMemoryMB = pICECDataBean.getConfigurableMemory().longValue();
        mOXContainerObj2 = pICECDataBean.getHypervisorMemory();
        if (mOXContainerObj2 != null) {
            this.m_sAvailableMem = Long.toString(this.m_configMemoryMB - mOXContainerObj2.longValue());
            System.err.println("Available memory is  " + this.m_sAvailableMem);
        }
        this.m_minForMaxMemoryMB = 0L;
        this.m_minMemoryGB = 0;
        this.m_minMemoryMB = 0;
        this.m_desiredMemoryGB = 0;
        this.m_desiredMemoryMB = 0;
        this.m_maxMemoryGB = 0;
        this.m_maxMemoryMB = 0;
    }

    public String getAvailableMem() {
        return "" + this.m_sAvailableMem;
    }

    public void setAvailableMem(String string) {
        this.m_sAvailableMem = string;
    }

    public void setTotalMemoryMB(String string) throws IllegalUserDataException {
    }

    public String getTotalMemoryMB() {
        return "" + this.m_totalMemoryMB;
    }

    public void setMinForMaxMemoryMB(String string) throws IllegalUserDataException {
    }

    public String getMinForMaxMemoryMB() {
        return "" + this.m_minForMaxMemoryMB;
    }

    public void setMinMemoryGB(double d) throws IllegalUserDataException {
        this.m_minMemoryGB = (int)Math.rint(d);
    }

    public double getMinMemoryGB() {
        return this.m_minMemoryGB;
    }

    public void setMinMemoryMB(double d) throws IllegalUserDataException {
        this.m_minMemoryMB = (int)Math.rint(d);
    }

    public double getMinMemoryMB() {
        return this.m_minMemoryMB;
    }

    public void setDesiredMemoryGB(double d) throws IllegalUserDataException {
        this.m_desiredMemoryGB = (int)Math.rint(d);
    }

    public double getDesiredMemoryGB() {
        return this.m_desiredMemoryGB;
    }

    public void setDesiredMemoryMB(double d) throws IllegalUserDataException {
        this.m_desiredMemoryMB = (int)Math.rint(d);
    }

    public double getDesiredMemoryMB() {
        return this.m_desiredMemoryMB;
    }

    public void setMaxMemoryGB(double d) throws IllegalUserDataException {
        this.m_maxMemoryGB = (int)Math.rint(d);
    }

    public double getMaxMemoryGB() {
        return this.m_maxMemoryGB;
    }

    public void setMaxMemoryMB(double d) throws IllegalUserDataException {
        this.m_maxMemoryMB = (int)Math.rint(d);
    }

    public double getMaxMemoryMB() {
        return this.m_maxMemoryMB;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        UnsignedInt32 unsignedInt32;
        UnsignedInt32 unsignedInt322;
        UnsignedInt32 unsignedInt323 = this.m_cimProfileBean.getMinMem();
        if (unsignedInt323 != null) {
            long l = unsignedInt323.longValue();
            this.m_minMemoryGB = (int)l / 1024;
            this.m_minMemoryMB = (int)l % 1024;
        }
        if ((unsignedInt322 = this.m_cimProfileBean.getDesiredMem()) != null) {
            long l = unsignedInt322.longValue();
            this.m_desiredMemoryGB = (int)l / 1024;
            this.m_desiredMemoryMB = (int)l % 1024;
        }
        if ((unsignedInt32 = this.m_cimProfileBean.getMaxMem()) != null) {
            long l = unsignedInt32.longValue();
            this.m_maxMemoryGB = (int)l / 1024;
            this.m_maxMemoryMB = (int)l % 1024;
        }
        try {
            this.updateRequiredMinForMax();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        String string = null;
        UserTaskManager userTaskManager = null;
        boolean bl = false;
        boolean bl2 = false;
        userTaskManager = this.getUTM();
        Object[] objectArray = userTaskManager.getDataObjects();
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            if (!(object instanceof PIFullSysProfBean)) continue;
            PIFullSysProfBean pIFullSysProfBean = (PIFullSysProfBean)object;
            bl2 = pIFullSysProfBean.isprofileType();
        }
        if (!bl2) {
            long l = this.getMinMemory();
            long l2 = this.getMemory();
            long l3 = this.getMaxMemory();
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.getMemory() > this.m_configMemoryMB || this.getMaxMemory() > this.m_totalMemoryMB || this.getMinMemory() > this.m_configMemoryMB) {
                stringBuffer.append(NOT_ENOUGH_CONFIGURABLE_MEMORY).append("\n");
                bl = true;
            }
            if (l > l2) {
                stringBuffer.append(DESIRED_MEMORY_NOT_IN_RANGE).append("\n");
                bl = true;
            } else if (l2 > l3) {
                stringBuffer.append(DESIRED_MEMORY_NOT_IN_RANGE).append("\n");
                bl = true;
            }
            if (l2 == 0L || l == 0L || l3 == 0L) {
                stringBuffer.append(ZERO_MEMORY_ERROR).append("\n");
                bl = true;
            }
            try {
                this.updateRequiredMinForMax();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.m_minForMaxMemoryMB > l) {
                stringBuffer.append(MIN_MEMORY_TOO_SMALL_FOR_MAX).append("  ");
                bl = true;
                stringBuffer.append(HSCResourceBundleUtil.getMessage("ProfileBundle", "REQUIRED_MIN_MEMORY_FOR_MAX", "NLS_MESSAGE_NOT_FOUND", new String[]{"" + this.m_minForMaxMemoryMB}));
            }
            string = stringBuffer.toString();
        }
        if (bl) {
            throw new IllegalUserDataException(string);
        }
    }

    public void save() {
        long l = this.getMinMemory();
        long l2 = this.getMemory();
        long l3 = this.getMaxMemory();
        this.m_cimProfileBean.setMinMem(new UnsignedInt32(l));
        this.m_cimProfileBean.setDesiredMem(new UnsignedInt32(l2));
        this.m_cimProfileBean.setMaxMem(new UnsignedInt32(l3));
        if (IDebug.enabled()) {
            System.err.println("Memory: " + this.m_cimProfileBean);
        }
    }

    public void recalculateMinForMax(UserTaskManager userTaskManager) throws IllegalUserDataException {
        userTaskManager.storeContainer(MAX_GROUP_S);
        try {
            this.updateRequiredMinForMax();
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            new TaskMessage(userTaskManager, stringWriter.toString(), 1).invoke();
        }
        userTaskManager.refreshElement(MIN_FOR_MAX_S);
    }

    private long getMinMemory() {
        return (long)this.m_minMemoryGB * 1024L + (long)this.m_minMemoryMB;
    }

    private long getMemory() {
        return (long)this.m_desiredMemoryGB * 1024L + (long)this.m_desiredMemoryMB;
    }

    private long getMaxMemory() {
        return (long)this.m_maxMemoryGB * 1024L + (long)this.m_maxMemoryMB;
    }

    private void updateRequiredMinForMax() throws Throwable {
        this.m_minForMaxMemoryMB = this.getMinForMax(this.getMaxMemory() / (long)this.m_memoryRegionSize);
    }

    private long getMinForMax(long l) throws Throwable {
        System.err.println("getMinForMax.....");
        UnsignedInt32 unsignedInt32 = null;
        Object[] objectArray = null;
        if (this.m_moClass != null) {
            UnsignedInt8 unsignedInt8 = this.m_cimProfileBean.getOsType();
            if (unsignedInt8 == null) {
                unsignedInt8 = new UnsignedInt8(1);
            }
            objectArray = new Object[]{this.m_moxObj, unsignedInt8, new UnsignedInt32(l)};
            unsignedInt32 = (UnsignedInt32)this.m_moClass.invokeStaticMethod("queryRequiredMinMemoryForMax", objectArray);
        } else {
            objectArray = new Object[]{new UnsignedInt32(l)};
            unsignedInt32 = (UnsignedInt32)this.m_mobject.invokeMethod("queryRequiredMinMemoryForMax", objectArray);
        }
        if (unsignedInt32 != null) {
            return unsignedInt32.longValue();
        }
        return 0L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PIProfileMemoryDataBean [ ");
        stringBuffer.append("MinMemory = ").append(this.getMinMemory()).append(", ");
        stringBuffer.append("DesiredMemory = ").append(this.getMemory()).append(", ");
        stringBuffer.append("MaxMemory = ").append(this.getMaxMemory()).append(", ");
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

